| package |
package := Package name: 'Pst-Base-Dolphin'.
package paxVersion: 0;
	basicComment: 'Pocket Smalltalk 1.6
Copyright (c) 1998-2001 www.PocketSmalltalk.com
GEOS changes and enhancements: Copyright (c) 1999, 2000 by Petr Novak
Toolbar enhancements: Copyright (c) 2000 by Joey Gibson (joeyGibson@mindspring.com)

This product is Open Source - see LICENSE.TXT for more information.
Home page: http://www.pocketsmalltalk.com
GEOS version home page: http://www.i.cz/PeN/pst9110.html
SE version: http://www.joeygibson.com/st

After filing in this package, evaluate the following to open a launcher (you can replace initSystem
with initGeosSystem or initPalmOSSystem):

	Pst initPalmOsSystem.
	PstLauncher show.'.

package basicPackageVersion: ''.

"Add the package scripts"
package basicScriptAt: #postinstall put: 'PstDolphinInterface initialize.'.
package basicScriptAt: #preuninstall put: 'PstExceptionInterface default: nil.'.

"Add the class names, loose method names, global names, resource names"
package classNames
	add: #PstCompilerError;
	add: #PstCompilerWarning;
	add: #PstDolphinInterface;
	add: #PstProgressNotification;
	yourself.

package methodNames
	yourself.

package globalNames
	yourself.

package resourceNames
	yourself.

"Binary Global Names"
package binaryGlobalNames: (Set new
	yourself).
"Resource Names"
package allResourceNames: (Set new
	yourself).

"Add the prerequisite names"
package setPrerequisites: (IdentitySet new
	add: 'Dolphin';
	add: 'Pst-Base';
	yourself).

package!

"Class Definitions"!

Error subclass: #PstCompilerError
	instanceVariableNames: 'message start stop'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Notification subclass: #PstCompilerWarning
	instanceVariableNames: 'message start stop'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Notification subclass: #PstProgressNotification
	instanceVariableNames: 'percentComplete'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstCrossPlatformInterface subclass: #PstDolphinInterface
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
"Loose Methods"!

"End of package definition"!



PstCompilerError comment: ''!

PstCompilerError guid: (GUID fromString: '{A9A77418-4555-4033-811A-B027F3CA3DF5}')!

!PstCompilerError categoriesForClass!No category! !
!PstCompilerError methodsFor!

message
	"Answer the value of the receiver's instance variable message.
	This method was automatically generated, but may be modified."

	^message!

message: anObject
	"Set the value of the receiver's instance variable message to anObject.
	This method was automatically generated, but may be modified."

	message := anObject!

start
	"Answer the value of the receiver's instance variable start.
	This method was automatically generated, but may be modified."

	^start!

start: anObject
	"Set the value of the receiver's instance variable start to anObject.
	This method was automatically generated, but may be modified."

	start := anObject!

stop
	"Answer the value of the receiver's instance variable stop.
	This method was automatically generated, but may be modified."

	^stop!

stop: anObject
	"Set the value of the receiver's instance variable stop to anObject.
	This method was automatically generated, but may be modified."

	stop := anObject! !
!PstCompilerError categoriesFor: #message!accessing!public! !
!PstCompilerError categoriesFor: #message:!accessing!public! !
!PstCompilerError categoriesFor: #start!accessing!public! !
!PstCompilerError categoriesFor: #start:!accessing!public! !
!PstCompilerError categoriesFor: #stop!accessing!public! !
!PstCompilerError categoriesFor: #stop:!accessing!public! !



PstCompilerWarning comment: ''!

PstCompilerWarning guid: (GUID fromString: '{CCD9F045-7596-4AD4-91B0-0268B7E0F1F1}')!

!PstCompilerWarning categoriesForClass!No category! !
!PstCompilerWarning methodsFor!

message
	"Answer the value of the receiver's instance variable message.
	This method was automatically generated, but may be modified."

	^message!

message: anObject
	"Set the value of the receiver's instance variable message to anObject.
	This method was automatically generated, but may be modified."

	message := anObject!

start
	"Answer the value of the receiver's instance variable start.
	This method was automatically generated, but may be modified."

	^start!

start: anObject
	"Set the value of the receiver's instance variable start to anObject.
	This method was automatically generated, but may be modified."

	start := anObject!

stop
	"Answer the value of the receiver's instance variable stop.
	This method was automatically generated, but may be modified."

	^stop!

stop: anObject
	"Set the value of the receiver's instance variable stop to anObject.
	This method was automatically generated, but may be modified."

	stop := anObject! !
!PstCompilerWarning categoriesFor: #message!accessing!public! !
!PstCompilerWarning categoriesFor: #message:!accessing!public! !
!PstCompilerWarning categoriesFor: #start!accessing!public! !
!PstCompilerWarning categoriesFor: #start:!accessing!public! !
!PstCompilerWarning categoriesFor: #stop!accessing!public! !
!PstCompilerWarning categoriesFor: #stop:!accessing!public! !



PstProgressNotification comment: ''!

PstProgressNotification guid: (GUID fromString: '{992574B6-CB8C-4CC0-9264-C6FDB0C985B3}')!

!PstProgressNotification categoriesForClass!Unclassified! !
!PstProgressNotification methodsFor!

_descriptionArguments
	"Answer the arguments to be substitued into the receiver's Win32 description format String."

	^Array with: self percentComplete displayString!

_descriptionFormat
	"Answer the Win32 format String to be used to format the description for the receiver."

	^'Progress Notification: %1 complete.'!

percentComplete

	^percentComplete!

percentComplete: anInteger

	percentComplete := anInteger! !
!PstProgressNotification categoriesFor: #_descriptionArguments!displaying!public! !
!PstProgressNotification categoriesFor: #_descriptionFormat!displaying!public! !
!PstProgressNotification categoriesFor: #percentComplete!displaying!public! !
!PstProgressNotification categoriesFor: #percentComplete:!displaying!public! !

!PstProgressNotification class methodsFor!

percentComplete: anInteger

	^self new
		percentComplete: anInteger;
		signal! !
!PstProgressNotification class categoriesFor: #percentComplete:!instance creation!public! !



PstDolphinInterface comment: ''!

PstDolphinInterface guid: (GUID fromString: '{7D9CBB61-5AC1-4AC1-BFC9-ED3C278200BB}')!

!PstDolphinInterface categoriesForClass!Unclassified! !
!PstDolphinInterface methodsFor!

appendToFileNamed: fileName
	"	fileName		<String>
		^		<FileStream>
	Return a file stream to write to file name filename, and set to the end of its current contents."

	^FileStream write: fileName mode: #append!

combinePath: path withOtherPath: other
	"	path		<String>
		other	<String>
		^		<String>
	Return the combination of path with other under my current OS platform requirements."

	^File composePath: path subPath: other!

confirm: message
	"	message	<String>
		^		<Boolean>
	Popup a comfirmation message and wait till users selects yes or no."

	^MessageBox confirm: message!

defaultPath
	"	^	<String>
	Return the path that we are running in."

	^SessionManager current imageBase!

do: do onCompilerErrorDo: error onCompilerWarningDo: warning
	"	do	[void]
		error	[:<Exception> | void]
		warning	[:<Exception> | void]
		^		do value | error value | warning value
	Evaluate do.  If no errors or warning occur, return its result.
	If an error occurs, return the value of error.  If a warning
	occurs, return the value of warning."

	do
		on: PstCompilerError
		do: error
		on: PstCompilerWarning
		do: warning!

do: aBlock onProgressNotificationDo: notificationBlock

	aBlock
		on: PstProgressNotification 
		do: notificationBlock
!

eightBytesOfDouble: double
	"	double	<Double>
		^		<ByteArray new: 8>
	"

	| bytes |
	bytes := ByteArray new: 8.
		"Done this way in order to take into account the architecture of the destination VM"
	PstSystem current doubleByteOrder keysAndValuesDo: [:r :n |
		bytes at: r put: (double value basicAt: n)].
	^bytes.!

errorMsg: message caption: aCaption
	"	message	<String>
		aCaption <String>
		^		void
	Popup an error notification and wait till users oks.
	#wjg."

	^MessageBox errorMsg: message caption: aCaption.

!

existsFileNamed: fileName
	"	fileName		<String>
		^		<Boolean>
	Return true if the file named fileName exists."

	^File exists: fileName!

fileNamesMatching: pattern
	"	pattern		<String>
		^		<Collection withAll: <String>>
	Return the name of all files matching patter.  Pattern can include a path.
	Returned file names do not have the path"

	^(File find: pattern) collect: [:each | each fileName]!

fullPathOf: pathname relativeTo: basePath
	"	pathName	<String>
		basePath		<String>
	Answers the full path of pathname. If this is a truly relative
	path then it is formed as relative to basePath"

	^File fullPathOf: pathname relativeTo: basePath!

notify: message
	"	message	<String>
		^		void
	Popup a notification of message and wait till users oks."

	^MessageBox notify: message
!

objectOnSTBInFilerFileNamed: fileName
	"	fileName		<String>
		^		<Object>
	Return the object I find in fileName, that has been put out by Dolphin's STBOutFiler."

	| stream filer result |
	stream := FileStream read: fileName text: false.
	filer := STBInFiler on: stream.
	result := filer next.
	stream close.
	^result!

openReadOnly: readOnly fileNamed: fileName asText: asText
	"	readOnly		<Boolean>
		fileName		<String>
		asText		<Boolean>
		^		<FileStream>
	Return a file stream on fileName that is read-only if read-only is true and binary if asText is false."

	^readOnly
		ifTrue: [FileStream read: fileName text: asText]
		ifFalse: [FileStream write: fileName text: asText]!

raiseCompilerError: message start: start stop: stop
	"	message	<String>
		start		<Integer>
		stop		<Integer>
		^		void
	Raise the compiler error.  start and stop are the character index of where the warning is for."

	PstCompilerError new
		message: message;
		start: start;
		stop: stop;
		signal!

raiseCompilerWarning: message start: start stop: stop
	"	message	<String>
		start		<Integer>
		stop		<Integer>
		^		void
	Raise the compiler warning.  start and stop are the character index of where the warning is for."

	PstCompilerWarning new
		message: message;
		start: start;
		stop: stop;
		signal!

raiseProgressNotification: percentComplete
	"Raise the progress notification."

	PstProgressNotification percentComplete: percentComplete!

relativePathOf: aPathString to: aBasePathString
	"Answers the relative path of aPathString relative to aBasePathString.
	As of release 2.2 this always answers a true relative path, sometimes using \..\
	components to back up the directory hierarchy towards the root.
	Note that this routine is not terribly fast, as it uses the services of file
	monikers in order to guarantee correctness."

	^File relativePathOf: aPathString to: aBasePathString!

secondsSinceJan011904
	"	^	<Integer>
	Return the number of seconds since January 01, 1904."

	^TimeStamp current asSeconds - (Date newDay: 1 monthIndex: 1 year: 1904) asSeconds.!

setProgressValueOf: dialog to: value
	"	dialog	<???>
		value	1..100
		^		void
	dialog is whatever is passed into the showProgessWhile: argument of
	showProgressWhile:withCaption:."

	dialog value: value
!

showProgressWhile: do withCaption: caption
	"	do	[:dialog <???> | <Object>]
		caption	<String>
		^		do value
	The range of progress is from 1 to: 100.
	Use setProgressValueOf:to: to set the progress."

	| result dialog |
	dialog := ProgressDialog operation: [:dialog | result := do value: dialog].
	dialog caption: caption;
		allowCancel: false;
		showModal.
	^result!

showWaitWhile: do
	"	do	[<Object>]
		^		do value
	Show wait cursor while do is executing."

	^Cursor wait showWhile: do!

splitExtensionFromFileName: fileName
	"	fileName	<String>
		^	<String>
	Return the extension of fileName, without the '.'."

	^File splitExtensionFrom: fileName!

splitFileNameFromFileName: fileName
	"	fileName	<String>
		^	<String>
	Return the file name of fileName."

	^File splitFilenameFrom: fileName!

splitPathFromFileName: fileName
	"	fileName	<String>
		^	<String>
	Return the path of fileName."

	^File splitPathFrom: fileName!

splitStemFromFileName: fileName
	"	fileName	<String>
		^	<String>
	Return the stem of fileName."

	^File splitStemFrom: fileName!

stbOutFilerNextPutObject: object on: stream
	"	object	<Object>
		stream	<WriteStream>
		^		void
	Put object onto stream using Dolphin's STBOutFiler format."

	(STBOutFiler on: stream)
		nextPut: object.! !
!PstDolphinInterface categoriesFor: #appendToFileNamed:!file operations!public! !
!PstDolphinInterface categoriesFor: #combinePath:withOtherPath:!file operations!public! !
!PstDolphinInterface categoriesFor: #confirm:!public!ui! !
!PstDolphinInterface categoriesFor: #defaultPath!file operations!public! !
!PstDolphinInterface categoriesFor: #do:onCompilerErrorDo:onCompilerWarningDo:!exceptions!public! !
!PstDolphinInterface categoriesFor: #do:onProgressNotificationDo:!public!ui! !
!PstDolphinInterface categoriesFor: #eightBytesOfDouble:!file operations!public! !
!PstDolphinInterface categoriesFor: #errorMsg:caption:!public!ui! !
!PstDolphinInterface categoriesFor: #existsFileNamed:!file operations!public! !
!PstDolphinInterface categoriesFor: #fileNamesMatching:!file operations!public! !
!PstDolphinInterface categoriesFor: #fullPathOf:relativeTo:!file operations!public! !
!PstDolphinInterface categoriesFor: #notify:!public!ui! !
!PstDolphinInterface categoriesFor: #objectOnSTBInFilerFileNamed:!object!public! !
!PstDolphinInterface categoriesFor: #openReadOnly:fileNamed:asText:!file operations!public! !
!PstDolphinInterface categoriesFor: #raiseCompilerError:start:stop:!exceptions!public! !
!PstDolphinInterface categoriesFor: #raiseCompilerWarning:start:stop:!exceptions!public! !
!PstDolphinInterface categoriesFor: #raiseProgressNotification:!public!ui! !
!PstDolphinInterface categoriesFor: #relativePathOf:to:!file operations!public! !
!PstDolphinInterface categoriesFor: #secondsSinceJan011904!public!time! !
!PstDolphinInterface categoriesFor: #setProgressValueOf:to:!public!ui! !
!PstDolphinInterface categoriesFor: #showProgressWhile:withCaption:!public!ui! !
!PstDolphinInterface categoriesFor: #showWaitWhile:!public!ui! !
!PstDolphinInterface categoriesFor: #splitExtensionFromFileName:!file operations!public! !
!PstDolphinInterface categoriesFor: #splitFileNameFromFileName:!file operations!public! !
!PstDolphinInterface categoriesFor: #splitPathFromFileName:!file operations!public! !
!PstDolphinInterface categoriesFor: #splitStemFromFileName:!file operations!public! !
!PstDolphinInterface categoriesFor: #stbOutFilerNextPutObject:on:!object!public! !

!PstDolphinInterface class methodsFor!

initialize
	"	^	self
	Set myself up as the default cross platform interface."
	"PstDolphinInterface initialize"

	self default: PstDolphinInterface new! !
!PstDolphinInterface class categoriesFor: #initialize!*-unclassified!public! !

 
"Binary Globals"!

"Resources"!

